# Analyses for Thompson, Grady, Morrison (2025) Does explaining the meaning of likelihood ratios improve lay understanding?

# Before running this script:
# Install package, if not already installed:
# 		install.packages("abtest")

# Load package:
library(abtest)


# Prior parameter vales
prior_par = list(mu_psi=0, sigma_psi=1, mu_beta=0, sigma_beta=1)


# ORTHODOXY
# effective LR = presented LR, excluding participants with prior odds = 1

# Data
# y1 = positive for no-explanation condition
# n1 = total number for no-explanation condition
# y2 = positive for explanation condition
# n2 = total number for explanation condition
data <- list(y1=2, n1=272, y2=7, n2=232)

# Test
prior_prob <- c(0, 0.5, 0, 0.5)
names(prior_prob) <- c("H1", "H+", "H-", "H0")
set.seed(0) # to get same result each time
AB <- ab_test(data = data, prior_par = prior_par, prior_prob = prior_prob)

# Print results
print("ORTHODOXY")
print("the relevant result is BF+0")
print(AB)


# PROSECUTOR'S FALLACY
# posterior odds = presented LR, excluding participants with prior odds = 1

# Data
# y1 = positive for no-explanation condition
# n1 = total number for no-explanation condition
# y2 = positive for explanation condition
# n2 = total number for explanation condition
data <- list(y1=47, n1=272, y2=31, n2=232)

# Test
prior_prob <- c(0, 0, 0.5, 0.5)
names(prior_prob) <- c("H1", "H+", "H-", "H0")
set.seed(0) # to get same result each time
AB <- ab_test(data = data, prior_par = prior_par, prior_prob = prior_prob)

# Print results
print("PROSECUTOR'S FALLACY")
print("the relevant result is BF-0")
print(AB)

